// awesomeProject1
//
// @(#)sse.go  星期五, 二月 28, 2025
// Copyright(c) 2025, reinhold@Tencent. All rights reserved.

package model

type DocParseEvent struct {
	Type      string `json:"type"`
	Payload   Payload
	MessageID string `json:"message_id"`
}

type Payload struct {
	DocID        string `json:"doc_id"`
	ErrorMessage string `json:"error_message"`
	IsFinal      bool   `json:"is_final"`
	Process      int    `json:"process"`
	SessionID    string `json:"session_id"`
	Status       string `json:"status"`
	Timestamp    int64  `json:"timestamp"`
	TraceID      string `json:"trace_id"`
}

type DescribeStorageCredential struct {
	Response struct {
		Bucket      string `json:"Bucket"`
		CorpUin     string `json:"CorpUin"`
		Credentials struct {
			TmpSecretId  string `json:"TmpSecretId"`
			TmpSecretKey string `json:"TmpSecretKey"`
			Token        string `json:"Token"`
		} `json:"Credentials"`
		ExpiredTime int    `json:"ExpiredTime"`
		FilePath    string `json:"FilePath"`
		ImagePath   string `json:"ImagePath"`
		Region      string `json:"Region"`
		RequestId   string `json:"RequestId"`
		StartTime   int    `json:"StartTime"`
		Type        string `json:"Type"`
		UploadPath  string `json:"UploadPath"`
	} `json:"Response"`
}

type DocParseRequest struct {
	SessionId string `json:"session_id"`
	RequestId string `json:"request_id"`
	CosBucket string `json:"cos_bucket"`
	FileType  string `json:"file_type"`
	FileName  string `json:"file_name"`
	CosUrl    string `json:"cos_url"`
	ETag      string `json:"e_tag"`
	CosHash   string `json:"cos_hash"`
	Size      string `json:"size"`
	BotAppKey string `json:"bot_app_key"`
}

// SseSendEvent SSE 发送事件
type SseSendEvent struct {
	Content           string     `json:"content"`
	BotAppKey         string     `json:"bot_app_key"`
	VisitorBizID      string     `json:"visitor_biz_id"`
	SessionID         string     `json:"session_id"`
	VisitorLabels     []Label    `json:"visitor_labels"`
	StreamingThrottle int        `json:"streaming_throttle"`
	FileInfos         []FileInfo `json:"file_infos"`
}

type FileInfo struct {
	DocId    string `json:"doc_id"`
	FileName string `json:"file_name"`
	FileType string `json:"file_type"`
	FileSize string `json:"file_size"`
	FileUrl  string `json:"file_url"`
}

// Label 标签
type Label struct {
	Name   string   `json:"name"`
	Values []string `json:"values"`
}
